capture log close
prog drop _all
set more off
set trace off
pause on
#delimit ;
clear;

global dir "D:\RA\Moffitt\Nicole_LS\091712";

use "$dir\Data\men_actual.dta";
rename employed men_actual;
/*merge year using "$dir\Data\men_marry.dta", sort; drop _merge;*/
merge year using "$dir\Data\men_nomarry.dta", sort; drop _merge;
merge year using "$dir\Data\women_actual.dta", sort; drop _merge;
rename employed women_actual;
/*merge year using "$dir\Data\women_marry.dta", sort; drop _merge;*/
merge year using "$dir\Data\women_nomarry.dta", sort; drop _merge;


gen str MenHypo="Male ratio using 1999 composition" if year==2004;
gen str MenAct="Actual male ratio" if year==2006;
gen str WomenHypo="Female ratio using 1999 composition" if year==2004;
gen str WomenAct="Actual female ratio" if year==2006;

/*
graph twoway 
	(connected men_marry year, ms(i) mcolor(blue) mlabel(MenHypo) mlabposition(6))
	(connected men_actual year, ms(i) mcolor(blue) lpattern(dash) mlabel(MenAct) mlabposition(12))
	(connected women_marry year, ms(i) mcolor(red) mlabel(WomenHypo) mlabposition(6))
	(connected women_actual year, ms(i) mcolor(red) lpattern(dash) mlabel(WomenAct) mlabposition(12)),
	title("Figure 3: Actual and Hypothetical Employment-Population Ratio",size(medium))
	subtitle("1989-2011, Fixed 1999 Demographic Composition")
	ytitle("Employment-Population Ratio" "    ")
	xtitle(" " "Year" )
	xline(2007, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	xline(1999, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	xline(1989, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	legend(off)
	xlabel(1989 1994 1999 2003 2007 2011);
	note("Fixed-Composition calculated by fixing 1999 age, gender, education, race and marriage proportions", size(vsmall));
graph export "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Figures for paper\pdfs\Figure3withmarry.emf", replace;
*/


graph twoway 
	(connected men_nomarry year, ms(i) mcolor(blue) mlabel(MenHypo) mlabposition(6))
	(connected men_actual year, ms(i) mcolor(blue) lpattern(dash) mlabel(MenAct) mlabposition(12))
	(connected women_nomarry year, ms(i) mcolor(red) mlabel(WomenHypo) mlabposition(6))
	(connected women_actual year, ms(i) mcolor(red) lpattern(dash) mlabel(WomenAct) mlabposition(12)),
	title("Figure 3: Actual and Hypothetical Employment-Population Ratio",size(medium))
	subtitle("1989-2011, Fixed 1999 Demographic Composition")
	ytitle("Employment-Population Ratio" "    ")
	xtitle(" " "Year" )
	xline(2007, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	xline(1999, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	xline(1989, lwidth(vvthin) lcolor(black) lpattern(shortdash))
	legend(off)
	xlabel(1989 1994 1999 2003 2007 2011)
	note("Fixed-Composition calculated by fixing 1999 age, gender, education, and race proportions", size(vsmall));
graph export "$dir\Figure3nomarry.eps", replace;
